from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.language_regional import LanguageRegionalSettings
from app.v1.services.platform import language_regional as language_service

router = APIRouter()

@router.get("/", response_model=LanguageRegionalSettings)
def get_settings(db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return language_service.get_language_regional_settings(db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=LanguageRegionalSettings)
def update_settings(account_id: str, settings: LanguageRegionalSettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return language_service.update_language_regional_settings(account_id,settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
